<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require __DIR__ . "/../config/admin.php";

$client = $_GET['client'] ?? "";
$id     = $_GET['id'] ?? "";

if (!$client || !$id) {
    die("Paramètres invalides.");
}

$paths = $config["paths"];

$baseClient = $paths["clients"] . "/$client";
$jsonFile   = "$baseClient/engins/$id.json";

if (!file_exists($jsonFile)) {
    die("Fichier engin introuvable : $jsonFile");
}

$data = json_decode(file_get_contents($jsonFile), true);
if (!is_array($data)) {
    die("JSON invalide.");
}

$marque      = $data["marque"] ?? "—";
$type        = $data["type"] ?? "—";
$numeroSerie = $data["numero_serie"] ?? "—";
$annee       = $data["annee"] ?? "—";

// 🔥 CHOIX A — NUMÉRO DE PARC = ID DU FICHIER
$numeroParc  = $id;

// VALIDITÉS
$validites = $data["validites"] ?? [];
$vgp       = $validites["vgp"] ?? null;
$assurance = $validites["assurance"] ?? null;

// DOCUMENTS
$docDir   = "$baseClient/documents/engins/$id";
$docUrl   = "/data/clients/$client/documents/engins/$id";

$documents = [];
if (is_dir($docDir)) {
    foreach (scandir($docDir) as $f) {
        if ($f !== "." && $f !== "..") {
            $documents[] = $f;
        }
    }
}

// CONTACTS CLIENT
$clientsConfig = $config["clients_admin_extra"] ?? [];
$responsable  = $clientsConfig[$client]["responsable_parc"] ?? null;
$panne        = $clientsConfig[$client]["urgence_panne"] ?? null;

// CSS
$blue   = "#0057d8";
$green  = "#009846";
$red    = "#c60000";
$grey   = "#444";
?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">
<title>Fiche Engin</title>

<style>
body {
    font-family: Arial, sans-serif;
    background: #f3f3f3;
    margin: 0;
}

.header {
    background: <?= $blue ?>;
    padding: 12px;
    color: white;
    display: flex;
    align-items: center;
}

.header img {
    height: 40px;
    margin-right: 10px;
}

.header span {
    margin-left: auto;
    font-weight: bold;
    font-size: 20px;
}

.section {
    background: white;
    margin: 12px;
    padding: 14px;
    border-radius: 6px;
}

.title {
    font-size: 18px;
    font-weight: bold;
    margin-bottom: 10px;
}

.btn {
    display: block;
    padding: 16px;
    margin-bottom: 12px;
    border-radius: 8px;
    text-align: center;
    font-weight: bold;
    color: white;
    text-decoration: none;
    font-size: 17px;
}

.btn-blue { background: <?= $blue ?>; }
.btn-green { background: <?= $green ?>; }
.btn-red { background: <?= $red ?>; }

.doc-item {
    display: block;
    background: <?= $grey ?>;
    color: white;
    padding: 12px;
    border-radius: 6px;
    margin-bottom: 6px;
    text-decoration: none;
}
</style>
</head>

<body>

<div class="header">
    <img src="/data/clients/<?= $client ?>/logos/logo.png" alt="logo">
    <span><?= $client ?></span>
</div>

<div class="section">
    <div class="title">Informations Engin</div>

    <b>Marque :</b> <?= $marque ?><br>
    <b>Type :</b> <?= $type ?><br>
    <b>Numéro de série :</b> <?= $numeroSerie ?><br>
    <b>Année :</b> <?= $annee ?><br>
    <b>Numéro de parc :</b> <?= $numeroParc ?><br><br>

    <b>Fin VGP :</b> <?= $vgp ?: "Non renseignée" ?><br>
    <b>Fin assurance :</b> <?= $assurance ?: "Non renseignée" ?><br>
</div>

<div class="section">
    <div class="title">Documents</div>

    <?php foreach ($documents as $doc): ?>
        <a class="doc-item" href="<?= $docUrl . "/" . $doc ?>">
            📄 <?= $doc ?>
        </a>
    <?php endforeach; ?>
</div>

<div class="section">
    <div class="title">Actions</div>

    <a class="btn btn-blue" href="engin-entretien.php?client=<?= $client ?>&id=<?= $id ?>">Historique entretien</a>
    <a class="btn btn-blue" href="engin-demande.php?client=<?= $client ?>&id=<?= $id ?>">Demande d'entretien</a>

    <?php if ($responsable): ?>
        <a class="btn btn-green" href="tel:<?= $responsable ?>">📞 Responsable de parc</a>
    <?php endif; ?>

    <?php if ($panne): ?>
        <a class="btn btn-red" href="tel:<?= $panne ?>">🚨 Appel en cas de PANNE</a>
    <?php endif; ?>

</div>

</body>
</html>

