<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$client = $_GET['client'] ?? '';
$id     = $_GET['id'] ?? '';

if ($client === '' || $id === '') die("Paramètres manquants.");

// Chargement config
$config = require __DIR__ . '/../config/admin.php';
$paths  = $config['paths'] ?? [];

// Dossiers
$clientDir = $paths['root'] . "/clients/$client";
$jsonFile  = "$clientDir/engins/$id.json";
$docsDir   = "$clientDir/documents/engins/$id";

if (!file_exists($jsonFile)) die("Fiche engin introuvable.");
$data = json_decode(file_get_contents($jsonFile), true);

// Logo client
$logoPath = "$clientDir/logos/logo.png";
$logoUrl  = file_exists($logoPath)
            ? "/data/clients/$client/logos/logo.png"
            : "https://via.placeholder.com/80x50/cccccc/666666?text=LOGO";

// Téléphones (NE SERONT PAS AFFICHÉS)
$responsable = $config['clients'][$client]['responsable_parc'] ?? '';
$panne       = $config['clients'][$client]['numero_panne'] ?? '';
?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">

<meta name="viewport" content="width=device-width, initial-scale=1">

<title>Fiche Engin</title>

<style>
    body {
        font-family: Arial, sans-serif;
        margin: 0;
        background: #f0f0f0;
        font-size: 16px;
    }

    /* Bandeau */
    .header {
        background: #005bbb;
        padding: 14px 20px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        color: white;
    }
    .header img { height: 50px; }

    .container {
        background: white;
        margin: 15px;
        padding: 18px;
        border-radius: 8px;
        box-shadow: 0 0 6px rgba(0,0,0,0.15);
    }

    h2 { margin-top: 0; font-size: 20px; }

    .info-line { margin: 8px 0; font-size: 16px; }

    .badge {
        padding: 6px 10px;
        border-radius: 5px;
        font-size: 14px;
        color: white;
        margin-left: 6px;
    }
    .badge-blue { background:#005bbb; }

    /* Boutons */
    .btn {
        display: block;
        width: 100%;
        padding: 16px;
        margin: 12px 0;
        background: #005bbb;
        color: white;
        border-radius: 10px;
        text-align: center;
        font-weight: bold;
        font-size: 18px;
        text-decoration: none;
    }

    .btn:hover { background: #004499; }

    .btn-green { background:#00a23c; }
    .btn-green:hover { background:#008f34; }

    .btn-red { background:#d00000; }
    .btn-red:hover { background:#a00000; }

    .doc-item {
        background: #e7f0ff;
        padding: 12px;
        margin: 6px 0;
        border-radius: 6px;
        font-size: 16px;
    }
</style>
</head>

<body>

<div class="header">
    <img src="<?php echo $logoUrl; ?>">
    <div style="font-size:22px; font-weight:bold;"><?php echo htmlspecialchars($client); ?></div>
</div>

<!-- INFOS ENGIN -->
<div class="container">
    <h2>Informations Engin</h2>

    <div class="info-line"><strong>Marque :</strong> <?php echo $data['marque']; ?></div>
    <div class="info-line"><strong>Type :</strong> <?php echo $data['type']; ?></div>
    <div class="info-line"><strong>Numéro de série :</strong> <?php echo $data['numero_serie']; ?></div>
    <div class="info-line"><strong>Année :</strong> <?php echo $data['annee']; ?></div>
    <div class="info-line"><strong>Numéro de parc :</strong> <?php echo $data['numero_parc']; ?></div>

    <div class="info-line">
        <strong>Fin VGP :</strong>
        <span class="badge badge-blue"><?php echo $data['vgp']; ?></span>
    </div>

    <div class="info-line">
        <strong>Fin assurance :</strong>
        <span class="badge badge-blue"><?php echo $data['assurance']; ?></span>
    </div>
</div>

<!-- DOCUMENTS -->
<div class="container">
    <h2>Documents</h2>

    <?php
    if (is_dir($docsDir)) {
        foreach (scandir($docsDir) as $f) {
            if ($f === "." || $f === "..") continue;
            echo "<div class='doc-item'><a href=\"/data/clients/$client/documents/engins/$id/$f\" target=\"_blank\">$f</a></div>";
        }
    } else {
        echo "<i>Aucun document.</i>";
    }
    ?>
</div>

<!-- ACTIONS -->
<div class="container">
    <h2>Actions</h2>

    <a class="btn" href="engin-entretien.php?client=<?php echo $client ?>&id=<?php echo $id ?>">
        Historique entretien
    </a>

    <a class="btn" href="engin-demande.php?client=<?php echo $client ?>&id=<?php echo $id ?>">
        Demande d'entretien
    </a>

    <!-- BOUTON RESPONSABLE DE PARC (numéro non affiché) -->
    <?php if ($responsable): ?>
        <a class="btn btn-green" href="tel:<?php echo $responsable; ?>">
            📞 Appeler le responsable de parc
        </a>
    <?php endif; ?>

    <!-- BOUTON PANNE (numéro non affiché) -->
    <?php if ($panne): ?>
        <a class="btn btn-red" href="tel:<?php echo $panne; ?>">
            <span style="display:flex; align-items:center; justify-content:center; gap:10px;">
                <svg width="26" height="26" viewBox="0 0 24 24" fill="white">
                    <path d="M6.62 10.79a15.053 15.053 0 006.59 6.59l2.2-2.2a1
                    1 0 011.05-.24 11.72 11.72 0 003.68.59 1 1 0 011 1V21a1 1 0 01-1
                    1A17 17 0 013 4a1 1 0 011-1h3.47a1 1 0 011 1 11.72 11.72 0 00.59
                    3.68 1 1 0 01-.24 1.05l-2.2 2.06z"/>
                </svg>
                🚨 Appel en cas de PANNE
            </span>
        </a>
    <?php endif; ?>

</div>

</body>
</html>
