<?php
// ==========================================
// PARAMÈTRES
// ==========================================
$client = $_GET["client"] ?? "";
$id     = $_GET["id"] ?? "";

if ($client === "" || $id === "") {
    die("Client ou ID manquant.");
}

// ==========================================
// CHEMINS
// ==========================================
$base = "/var/www/docnlink/data/clients/$client";
$settingsFile = "$base/settings.json";
$enginFile    = "$base/engins/$id.json";

// ==========================================
// CHARGEMENT settings.json
// ==========================================
if (!file_exists($settingsFile)) die("settings.json introuvable.");
$settings = json_decode(file_get_contents($settingsFile), true);
$nomClient = $settings["nom_client"] ?? $client;

// ==========================================
// CHARGEMENT DONNÉES ENGIN
// ==========================================
if (!file_exists($enginFile)) die("Fiche engin introuvable.");

$data = json_decode(file_get_contents($enginFile), true);
if (!is_array($data)) die("JSON invalide.");

$parc = $data["numero_parc"] ?? $id;

// ==========================================
// TRAITEMENT DU FORMULAIRE
// ==========================================
$message = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {

    $demande = [
        "nom"       => trim($_POST["nom"] ?? ""),
        "date"      => trim($_POST["date"] ?? ""),
        "heure_km"  => trim($_POST["heure_km"] ?? ""),
        "nature"    => trim($_POST["nature"] ?? "")
    ];

    // Création de la clé si absente
    if (!isset($data["demandes"]) || !is_array($data["demandes"])) {
        $data["demandes"] = [];
    }

    $data["demandes"][] = $demande;

    // Sauvegarde JSON
    file_put_contents($enginFile, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

    $message = "Votre demande a bien été enregistrée.";
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">
<title>Demande entretien - <?php echo htmlspecialchars($parc); ?></title>

<style>
body { font-family: Arial, sans-serif; background:#f7f7f7; margin:0; padding:0; }
.header { background:#0B5ED7; color:white; padding:15px; font-size:22px; font-weight:bold; }
.block { background:white; padding:15px; margin:15px; border-radius:6px; }
label { font-weight:bold; display:block; margin-top:10px; }
input, textarea { width:100%; padding:10px; border:1px solid #ccc; border-radius:4px; }
.btn {
    display:block; padding:12px; background:#0B5ED7; color:white;
    text-align:center; text-decoration:none; border-radius:6px;
    width:200px; margin-top:15px; cursor:pointer; border:none;
}
.success { background:#d4edda; padding:10px; border:1px solid #7ac27c; margin-bottom:15px; }
</style>
</head>

<body>

<div class="header">
    <?php echo htmlspecialchars($nomClient); ?> — Demande d’entretien (<?php echo htmlspecialchars($parc); ?>)
</div>

<div class="block">
    <h2>Formulaire de demande</h2>

    <?php if ($message): ?>
        <div class="success"><?php echo htmlspecialchars($message); ?></div>
    <?php endif; ?>

    <form method="post">

        <label>Nom</label>
        <input type="text" name="nom" required>

        <label>Date</label>
        <input type="date" name="date" required>

        <label>Heure / Km</label>
        <input type="text" name="heure_km" placeholder="ex : 1350h ou 12 500 km" required>

        <label>Nature de la demande</label>
        <textarea name="nature" rows="4" required></textarea>

        <button class="btn" type="submit">Envoyer</button>
    </form>
</div>

<div class="block">
    <a class="btn" href="engin.php?client=<?php echo $client; ?>&id=<?php echo $id; ?>">
        ⬅ Retour fiche engin
    </a>
</div>

</body>
</html>
