<?php
session_start();

// Si pas superadmin → pas le droit d'être ici
if (empty($_SESSION['logged']) || $_SESSION['role'] !== 'superadmin') {
    header("Location: admin-login.php");
    exit;
}

$config = require __DIR__ . '/../../config/admin.php';

// Liste des clients autorisés
$clientsList = array_keys($config["clients_admin"]);

// Récupération du code client envoyé
$clientCode = trim($_POST['client_code'] ?? "");

// Validation
if ($clientCode === "") {
    die("Erreur : aucun code client fourni.");
}

if (!in_array($clientCode, $clientsList)) {
    die("Erreur : client inconnu dans la configuration.");
}

// OK → on sélectionne ce client dans la session
$_SESSION['client'] = $clientCode;

// Retour au panneau
header("Location: admin-panel.php");
exit;
