<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// ======================================================
// Sécurité admin
// ======================================================
if (empty($_SESSION['logged']) || $_SESSION['logged'] !== true) {
    header("Location: admin-login.php");
    exit;
}

// ======================================================
// Paramètres
// ======================================================
$client = $_GET['client'] ?? '';
$id     = $_GET['id'] ?? '';

if ($client === '' || $id === '') {
    die("Paramètres invalides.");
}

$dataPath = "/var/www/docnlink/data/clients/$client/engins/$id.json";
$configPath = "/var/www/docnlink/config/contacts.json";

if (!file_exists($dataPath)) die("Fiche engin introuvable.");

$data = json_decode(file_get_contents($dataPath), true);
if (!is_array($data)) die("JSON invalide.");

$parc = $data['numero_parc'] ?? $id;

// ======================================================
// Charger nom du client
// ======================================================
$clientName = $client;
if (file_exists($configPath)) {
    $conf = json_decode(file_get_contents($configPath), true);
    if (!empty($conf["clients"][$client]["nom_client"])) {
        $clientName = $conf["clients"][$client]["nom_client"];
    }
}

// ======================================================
// Génération QR code (base64 PNG)
// ======================================================
function generateQR($text) {
    include_once "/var/www/docnlink/libs/phpqrcode/qrlib.php";

    ob_start();
    QRcode::png($text, null, QR_ECLEVEL_M, 4, 1);
    return base64_encode(ob_get_clean());
}

$url = "https://docnlink.fr/engin.php?client=$client&id=$id";
$qrBase64 = generateQR($url);

?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">
<title>QR — <?= htmlspecialchars($parc) ?></title>

<style>
body { font-family: Arial; background:#fff; margin:0; padding:20px; }

.label {
    width: 50mm;
    height: 80mm;
    border: 1px solid #000;
    padding: 5px;
    text-align: center;
}

.company {
    font-size: 16px;
    font-weight: bold;
    margin-bottom: 6px;
}

.parc {
    font-size: 18px;
    font-weight: bold;
    margin-top: 8px;
}

.btn {
    display:block;
    width:200px;
    padding:10px;
    background:#0057D9;
    color:white;
    text-align:center;
    border-radius:6px;
    margin-top:20px;
    text-decoration:none;
}
</style>
</head>

<body>

<div class="label">
    <div class="company"><?= htmlspecialchars($clientName) ?></div>

    <img src="data:image/png;base64,<?= $qrBase64 ?>" alt="QR">

    <div class="parc"><?= htmlspecialchars($parc) ?></div>
</div>

<br><br>

<a class="btn" href="admin-engin-fiche.php?client=<?= htmlspecialchars($client) ?>&id=<?= htmlspecialchars($id) ?>">
    ⬅ Retour fiche engin
</a>

</body>
</html>
