<?php
session_start();

// Redirection si pas connecté
if (empty($_SESSION['logged']) || $_SESSION['logged'] !== true) {
    header("Location: admin-login.php");
    exit;
}

$config = require __DIR__ . '/../../config/admin.php';

// Déterminer le rôle
$role   = $_SESSION['role'] ?? 'client';
$client = $_SESSION['client'] ?? null;

// Si superadmin mais aucun client sélectionné → affichage à part
$isSuperAdmin = ($role === 'superadmin');

?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Panneau d'administration</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 0; }
        header {
            background: #007bff;
            color: white;
            padding: 12px;
            font-size: 20px;
        }
        .container {
            padding: 20px;
        }
        .client-box, .menu-box {
            border: 1px solid #ccc;
            padding: 20px;
            margin-bottom: 25px;
            border-radius: 6px;
        }
        .menu-item {
            margin: 10px 0;
            font-size: 18px;
        }
        .menu-item a {
            text-decoration: none;
            color: #007bff;
        }
        .menu-item a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>

<header>
    Panneau d'administration
</header>

<div class="container">

    <?php if ($isSuperAdmin): ?>
        
        <div class="client-box">
            <h3>Mode superadmin</h3>
            <p>Vous êtes connecté en superadmin.</p>
            <p>Veuillez entrer un code client pour gérer un client :</p>

            <form method="post" action="select-client.php">
                <input type="text" name="client_code" placeholder="Code client" required>
                <button type="submit">Valider</button>
            </form>
        </div>

        <?php if ($client): ?>
            <div class="client-box">
                <strong>Client sélectionné :</strong> <?= htmlspecialchars($client) ?>
            </div>
        <?php endif; ?>

    <?php else: ?>

        <div class="client-box">
            <h3>Client : <?= htmlspecialchars($client) ?></h3>
            <p>Connecté avec droits administrateur.</p>
        </div>

    <?php endif; ?>


    <?php if ($client): ?>
    <div class="menu-box">
        <h3>Gestion du client</h3>

        <div class="menu-item"><a href="admin-create-engin.php?client=<?= $client ?>">➜ Créer un engin</a></div>
        <div class="menu-item"><a href="admin-documents-engin.php?client=<?= $client ?>">➜ Documents engins</a></div>

        <div class="menu-item"><a href="admin-create-camion.php?client=<?= $client ?>">➜ Créer un camion</a></div>
        <div class="menu-item"><a href="admin-documents-camion.php?client=<?= $client ?>">➜ Documents camions</a></div>

        <div class="menu-item"><a href="admin-create-salarie.php?client=<?= $client ?>">➜ Créer un salarié</a></div>
        <div class="menu-item"><a href="admin-documents-salarie.php?client=<?= $client ?>">➜ Documents salariés</a></div>

        <div class="menu-item"><a href="admin-entretien-global.php?client=<?= $client ?>">➜ Entretiens engins</a></div>
    </div>
    <?php endif; ?>

    <p><a href="admin-logout.php">Déconnexion</a></p>

</div>

</body>
</html>
