<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

// Chargement de la configuration

$config = require __DIR__ . '/../../config/admin.php';

$superAdmin     = $config['super_admin']      ?? [];
$clientsAdmin   = $config['clients_admin']    ?? [];
$paths          = $config['paths']            ?? [];

$error = "";

// Si déjà connecté => on envoie direct sur le panel
if (!empty($_SESSION['logged']) && $_SESSION['logged'] === true) {
    header("Location: admin-panel.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $clientCode = trim($_POST['client_code'] ?? '');
    $password   = trim($_POST['password'] ?? '');

    // Cas SUPERADMIN : login spécial, pas de client imposé
    if ($clientCode === ($superAdmin['login'] ?? '') && $password === ($superAdmin['password'] ?? '')) {

        $_SESSION['logged'] = true;
        $_SESSION['role']   = 'superadmin';
        $_SESSION['client'] = null; // il pourra choisir plus tard si on le souhaite

        header("Location: admin-panel.php");
        exit;
    }

    // Cas ADMIN CLIENT : code client + mot de passe client
    if ($clientCode !== '') {
        if (array_key_exists($clientCode, $clientsAdmin)) {
            $expectedPassword = $clientsAdmin[$clientCode];

            if ($password === $expectedPassword) {

                $_SESSION['logged'] = true;
                $_SESSION['role']   = 'client';
                $_SESSION['client'] = $clientCode;

                header("Location: admin-panel.php");
                exit;

            } else {
                $error = "Mot de passe incorrect pour ce client.";
            }
        } else {
            $error = "Code client inconnu.";
        }
    } else {
        $error = "Merci de saisir un code client.";
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Connexion administration</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background:#f0f0f0;
            margin:0;
            padding:0;
        }
        .login-container {
            max-width: 400px;
            margin: 80px auto;
            background:white;
            padding:20px;
            border-radius:8px;
            box-shadow:0 0 10px rgba(0,0,0,0.2);
        }
        h2 {
            margin-top:0;
        }
        label {
            font-weight:bold;
            display:block;
            margin-top:10px;
        }
        input[type="text"],
        input[type="password"] {
            width:100%;
            padding:8px;
            margin-top:5px;
            box-sizing:border-box;
        }
        button {
            margin-top:15px;
            width:100%;
            padding:10px;
            border:none;
            background:#007bff;
            color:white;
            font-size:16px;
            cursor:pointer;
            border-radius:4px;
        }
        button:hover {
            background:#0056b3;
        }
        .error {
            color:red;
            margin-top:10px;
        }
        .hint {
            font-size: 12px;
            color:#666;
            margin-top:8px;
        }
    </style>
</head>
<body>

<div class="login-container">
    <h2>Connexion administration</h2>

    <?php if ($error): ?>
        <div class="error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="post">
        <label for="client_code">Code client</label>
        <input type="text" id="client_code" name="client_code" required>

        <div class="hint">
            - Pour toi (super admin) : code client = <strong><?= htmlspecialchars($superAdmin['login'] ?? 'superadmin') ?></strong><br>
            - Pour un client : son code (ex : <strong>ECF_VIGIER</strong>)
        </div>

        <label for="password">Mot de passe</label>
        <input type="password" id="password" name="password" required>

        <button type="submit">Connexion</button>
    </form>
</div>

</body>
</html>
