<?php
session_start();

// Sécurité : interdit si non connecté
if (empty($_SESSION['logged']) || $_SESSION['logged'] !== true) {
    header("Location: admin-login.php");
    exit;
}

$role   = $_SESSION['role']   ?? 'client';
$client = $_SESSION['client'] ?? null;

// Chargement config
$config = require __DIR__ . "/../config/admin.php";
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Administration</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin:0;
            padding:0;
            background:#f5f5f5;
        }
        header {
            background:#007bff;
            color:white;
            padding:12px 20px;
            font-size:22px;
            font-weight:bold;
        }
        .subheader {
            background:#e7e7e7;
            padding:8px 20px;
            font-size:14px;
            color:#333;
            border-bottom:1px solid #ccc;
        }
        .container {
            padding: 20px;
        }
        a {
            color:#007bff;
            text-decoration:none;
        }
        a:hover {
            text-decoration:underline;
        }
    </style>
</head>
<body>

<header>
    Administration
</header>

<div class="subheader">
    <?php if ($role === 'superadmin'): ?>
        Mode superadmin
        <?php if ($client): ?>
            — client sélectionné : <strong><?= htmlspecialchars($client) ?></strong>
        <?php endif; ?>
    <?php else: ?>
        Client : <strong><?= htmlspecialchars($client) ?></strong>
    <?php endif; ?>

    — <a href="admin-logout.php">Déconnexion</a>
</div>

<div class="container">
