<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// ========================
// Sécurité
// ========================
if (empty($_SESSION['logged']) || $_SESSION['logged'] !== true) {
    header("Location: admin-login.php");
    exit;
}

// ========================
// Paramètres
// ========================
$client = $_GET['client'] ?? '';
$id     = $_GET['id'] ?? '';

if ($client === '' || $id === '') {
    die("Paramètres invalides.");
}

$basePath = "/var/www/docnlink/data";
$jsonPath = "$basePath/clients/$client/engins/$id.json";

if (!file_exists($jsonPath))
    die("Fiche engin introuvable.");

$data = json_decode(file_get_contents($jsonPath), true);
if (!is_array($data)) die("JSON invalide.");

if (!isset($data["entretiens"])) $data["entretiens"] = [];
if (!isset($data["demande_entretien"])) $data["demande_entretien"] = [];

function save_json($path, $array) {
    file_put_contents($path, json_encode($array, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

function h($s) { return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }

// ========================
// SUPPRESSION
// ========================
if (isset($_GET['delete'])) {
    $index = intval($_GET['delete']);
    if (isset($data["entretiens"][$index])) {
        unset($data["entretiens"][$index]);
        $data["entretiens"] = array_values($data["entretiens"]);
        save_json($jsonPath, $data);
    }
    header("Location: admin-entretien.php?client=$client&id=$id");
    exit;
}

// ========================
// AJOUT ENTRETIEN
// ========================
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $new = [
        "date"      => $_POST["date"] ?? "",
        "heure"     => $_POST["heure"] ?? "",
        "nature"    => $_POST["nature"] ?? "",
        "effectue_par" => $_POST["effectue_par"] ?? "",
        "responsable"  => $_POST["responsable"] ?? "",
    ];

    $data["entretiens"][] = $new;
    save_json($jsonPath, $data);

    header("Location: admin-entretien.php?client=$client&id=$id");
    exit;
}

// ========================
// Coloration dates
// ========================
function date_color($date) {
    if (!$date) return "none";

    $ts = strtotime($date);
    if (!$ts) return "none";

    $now = time();
    $diff = ($ts - $now) / 86400;

    if ($diff < 0) return "red";      // Échue
    if ($diff <= 30) return "orange"; // Dans 30 jours
    return "none";
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">
<title>Admin — Entretien</title>

<style>
body { font-family: Arial; background:#f5f5f5; margin:0; }
.header { background:#0057D9; color:white; padding:15px; font-size:20px; font-weight:bold; }
.container { padding:20px; }

.section { background:white; padding:15px; margin-bottom:20px; border-radius:8px; }
.title { font-size:18px; font-weight:bold; margin-bottom:10px; }

table { width:100%; border-collapse:collapse; }
th, td { padding:8px; border-bottom:1px solid #ddd; }
.red { background:#ffb3b3; }
.orange { background:#ffe0b3; }

.btn {
    display:block; width:100%; background:#0057D9;
    color:white; padding:12px; text-align:center;
    border-radius:6px; font-size:16px; text-decoration:none;
    margin-top:10px;
}
.btn-small {
    background:#c00000; padding:6px 10px; color:white;
    font-size:14px; border-radius:4px; text-decoration:none;
}
</style>
</head>

<body>

<div class="header">
ADMIN — Entretien — <?= h($client) ?> — Engin <?= h($data["numero_parc"] ?? $id) ?>
</div>

<div class="container">

    <!-- HISTORIQUE ENTRETIENS -->
    <div class="section">
        <div class="title">Historique des entretiens</div>

        <?php if (empty($data["entretiens"])): ?>
            <p>Aucun entretien enregistré.</p>

        <?php else: ?>
            <table>
                <tr>
                    <th>Date</th>
                    <th>Heure/Km</th>
                    <th>Nature</th>
                    <th>Effectué par</th>
                    <th>Responsable</th>
                    <th></th>
                </tr>

                <?php foreach ($data["entretiens"] as $i => $e): ?>
                    <?php $color = date_color($e["date"]); ?>
                    <tr class="<?= $color ?>">
                        <td><?= h($e["date"]) ?></td>
                        <td><?= h($e["heure"]) ?></td>
                        <td><?= h($e["nature"]) ?></td>
                        <td><?= h($e["effectue_par"]) ?></td>
                        <td><?= h($e["responsable"]) ?></td>

                        <td>
                            <a class="btn-small"
                               onclick="return confirm('Supprimer ?')"
                               href="admin-entretien.php?client=<?= h($client) ?>&id=<?= h($id) ?>&delete=<?= $i ?>">
                                Suppr
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>

            </table>
        <?php endif; ?>
    </div>


    <!-- DEMANDES D'ENTRETIEN OPERATEUR -->
    <div class="section">
        <div class="title">Demandes d'entretien (opérateur)</div>

        <?php if (empty($data["demande_entretien"])): ?>
            <p>Aucune demande.</p>

        <?php else: ?>
            <ul>
                <?php foreach ($data["demande_entretien"] as $d): ?>
                    <li>
                        <b><?= h($d["date"]) ?></b> —
                        <?= h($d["heure"]) ?> —
                        <?= h($d["nature"]) ?> —
                        (par <?= h($d["nom"]) ?>)
                    </li>
                <?php endforeach; ?>
            </ul>
        <?php endif; ?>
    </div>

    <!-- FORMULAIRE AJOUT -->
    <div class="section">
        <div class="title">Ajouter un entretien</div>

        <form method="post">

            <label>Date :</label><br>
            <input type="date" name="date" required><br><br>

            <label>Heure / Kilométrage :</label><br>
            <input type="text" name="heure" required><br><br>

            <label>Nature de la maintenance :</label><br>
            <input type="text" name="nature" required><br><br>

            <label>Effectué par :</label><br>
            <input type="text" name="effectue_par" required><br><br>

            <label>Nom responsable :</label><br>
            <input type="text" name="responsable" required><br><br>

            <button class="btn">Ajouter</button>
        </form>
    </div>

    <a class="btn" href="admin-engin-fiche.php?client=<?= h($client) ?>&id=<?= h($id) ?>">
        Retour fiche engin
    </a>

</div>
</body>
</html>

