<?php
// ==========================================================
//  QR CODE — ADMIN
// ==========================================================

include "admin-header.php";

// ID engin
$id = $_GET["id"] ?? "";
if ($id === "") die("ID manquant.");

// Dossiers client
$clientBase = $config["paths"]["clients"] . "/" . $client;
$enginsDir  = $clientBase . "/" . $config["paths"]["engins"];
$file       = $enginsDir . "/" . $id . ".json";

if (!file_exists($file)) die("Engin introuvable.");

$data = json_decode(file_get_contents($file), true);
if (!is_array($data)) die("JSON invalide.");

// Nom de la société pour l'étiquette
$clientJson = $clientBase . "/client.json";
$clientCfg = file_exists($clientJson) ? json_decode(file_get_contents($clientJson), true) : [];
$clientName = $clientCfg["nom"] ?? $client;

// URL qui sera encodée dans le QR Code
$qrUrl = "https://docnlink.fr/engin.php?client=" . urlencode($client) . "&id=" . urlencode($id);

// Générateur QR externe fiable
$qrImg = "https://api.qrserver.com/v1/create-qr-code/?size=350x350&data=" . urlencode($qrUrl);

?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">
<title>QR Code Engin</title>

<style>
body{
    font-family:Arial;
    padding:20px;
    background:#f5f5f5;
}
.container{
    width:350px;
    margin:auto;
    background:white;
    padding:20px;
    border:1px solid #ccc;
    text-align:center;
}
.title{
    font-size:22px;
    font-weight:bold;
    margin-bottom:10px;
}
.parc{
    margin-top:10px;
    font-size:20px;
    font-weight:bold;
}
.btn{
    display:inline-block;
    margin-top:20px;
    padding:10px 15px;
    background:#007bff;
    color:white;
    text-decoration:none;
    border-radius:5px;
}
.btn:hover{
    background:#0056b3;
}
</style>

</head>
<body>

<div class="container">

    <div class="title"><?= htmlspecialchars($clientName) ?></div>

    <img src="<?= $qrImg ?>" alt="QR Code">

    <div class="parc">
        <?= htmlspecialchars($data["numero_parc"]) ?>
    </div>

    <a class="btn" href="admin-engin-fiche.php?id=<?= urlencode($id) ?>">⬅ Retour fiche engin</a>

</div>

</body>
</html>
