<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// ========================
// Sécurité : accès admin
// ========================
if (empty($_SESSION['logged']) || $_SESSION['logged'] !== true) {
    header("Location: admin-login.php");
    exit;
}

// ========================
// Paramètres
// ========================
$client = $_GET['client'] ?? '';
$id     = $_GET['id'] ?? '';

if ($client === '' || $id === '') {
    http_response_code(400);
    die("Paramètres invalides.");
}

$basePath = "/var/www/docnlink/data";
$jsonPath = "$basePath/clients/$client/engins/$id.json";

if (!file_exists($jsonPath)) {
    http_response_code(404);
    die("Fiche engin introuvable.");
}

$data = json_decode(file_get_contents($jsonPath), true);
if (!is_array($data)) die("JSON invalide");

// ========================
// Documents
// ========================
$docsPath = "$basePath/clients/$client/documents/engins/$id";
$docs = is_dir($docsPath) ? array_values(array_diff(scandir($docsPath), ['.', '..'])) : [];

function h($s) { return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }

?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Admin — Fiche engin <?= h($data['numero_parc'] ?? $id) ?></title>
    <style>
        body { font-family: Arial; background: #f5f5f5; margin: 0; }

        .header {
            background: #0057D9; color: #fff;
            padding: 15px; font-size: 20px; font-weight: bold;
        }

        .container { padding: 20px; }
        .section {
            background: #fff; padding: 15px;
            margin-bottom: 20px; border-radius: 8px;
        }

        .title { font-size: 18px; font-weight: bold; margin-bottom: 10px; }

        .btn {
            display: block; width: 100%;
            background: #0057D9; color: #fff;
            padding: 12px; text-align: center;
            font-size: 16px; border-radius: 6px;
            text-decoration: none; margin-bottom: 12px;
        }
    </style>
</head>

<body>

<div class="header">
    ADMIN – <?= h($client) ?> — Engin <?= h($data['numero_parc'] ?? $id) ?>
</div>

<div class="container">

    <!-- Infos engin -->
    <div class="section">
        <div class="title">Informations Engin</div>

        <p><b>Marque :</b> <?= h($data['marque'] ?? '') ?></p>
        <p><b>Type :</b> <?= h($data['type'] ?? '') ?></p>
        <p><b>Numéro de série :</b> <?= h($data['numero_serie'] ?? '') ?></p>
        <p><b>Année :</b> <?= h($data['annee'] ?? '') ?></p>
        <p><b>Numéro de parc :</b> <?= h($data['numero_parc'] ?? '') ?></p>
    </div>

    <!-- Documents -->
    <div class="section">
        <div class="title">Documents</div>

        <?php if (empty($docs)): ?>
            <p>Aucun document trouvé.</p>
        <?php else: ?>
            <?php foreach ($docs as $doc): ?>
                <a class="btn" target="_blank"
                   href="/data/clients/<?= h($client) ?>/documents/engins/<?= h($id) ?>/<?= h($doc) ?>">
                    <?= h($doc) ?>
                </a>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>

    <!-- Boutons admin -->
    <div class="section">
        <div class="title">Actions administrateur</div>

        <a class="btn"
           href="admin-documents-engin.php?client=<?= h($client) ?>&id=<?= h($id) ?>">
            Documents (modifier / ajouter)
        </a>

        <a class="btn"
           href="admin-entretien.php?client=<?= h($client) ?>&id=<?= h($id) ?>">
            Entretien (historique + gestion)
        </a>

        <a class="btn"
           href="admin-print-qr.php?client=<?= h($client) ?>&id=<?= h($id) ?>">
            QR Code
        </a>

        <a class="btn"
           href="admin-panel.php">
            Retour admin
        </a>
    </div>

</div>
</body>
</html>
