<?php
// ==========================================================
//  ENTRETIENS — ADMIN
// ==========================================================

include "admin-header.php";

$id = $_GET["id"] ?? "";
if ($id === "") die("ID manquant.");

// Chemins
$clientBase = $config["paths"]["clients"] . "/" . $client;
$jsonFile   = $clientBase . "/" . $config["paths"]["engins"] . "/" . $id . ".json";

// Vérif engin
if (!file_exists($jsonFile)) {
    die("Engin introuvable : " . htmlspecialchars($id));
}

$data = json_decode(file_get_contents($jsonFile), true);
if (!is_array($data)) die("JSON engin invalide.");

$entretiens = $data["entretiens"] ?? [];
$demandes   = $data["demandes"] ?? [];

?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">
<title>Entretiens engin admin</title>

<style>
.table{
    width:100%;
    border-collapse:collapse;
    margin-top:20px;
}
.table th, .table td{
    border:1px solid #ccc;
    padding:10px;
    background:white;
}
.table th{
    background:#007bff;
    color:white;
}
h3{ margin-top:30px; }
.btn{
    display:inline-block;
    padding:10px 15px;
    background:#007bff;
    color:white;
    text-decoration:none;
    border-radius:5px;
    margin-top:20px;
}
.btn:hover{ background:#0056b3; }
</style>

</head>
<body>

<h2>Entretiens – Engin <?= htmlspecialchars($id) ?></h2>

<!-- ===================================================== -->
<!--  DEMANDES D’ENTRETIEN                                 -->
<!-- ===================================================== -->

<h3>Demandes d’entretien</h3>

<table class="table">
<tr>
    <th>Nom</th>
    <th>Date</th>
    <th>Heures/Km</th>
    <th>Nature</th>
</tr>

<?php if (empty($demandes)): ?>
<tr><td colspan="4" style="text-align:center;">Aucune demande</td></tr>
<?php else: ?>
<?php foreach ($demandes as $d): ?>
<tr>
    <td><?= htmlspecialchars($d["nom"]) ?></td>
    <td><?= htmlspecialchars($d["date"]) ?></td>
    <td><?= htmlspecialchars($d["heures_km"]) ?></td>
    <td><?= htmlspecialchars($d["nature"]) ?></td>
</tr>
<?php endforeach; ?>
<?php endif; ?>
</table>


<!-- ===================================================== -->
<!--  ENTRETIENS RÉALISÉS                                  -->
<!-- ===================================================== -->

<h3>Entretiens réalisés</h3>

<table class="table">
<tr>
    <th>Date</th>
    <th>Heures/Km</th>
    <th>Nature</th>
    <th>Effectué par</th>
    <th>Responsable</th>
</tr>

<?php if (empty($entretiens)): ?>
<tr><td colspan="5" style="text-align:center;">Aucun entretien enregistré</td></tr>
<?php else: ?>
<?php foreach ($entretiens as $e): ?>
<tr>
    <td><?= htmlspecialchars($e["date"]) ?></td>
    <td><?= htmlspecialchars($e["heures_km"]) ?></td>
    <td><?= htmlspecialchars($e["nature"]) ?></td>
    <td><?= htmlspecialchars($e["effectue_par"]) ?></td>
    <td><?= htmlspecialchars($e["responsable"]) ?></td>
</tr>
<?php endforeach; ?>
<?php endif; ?>
</table>


<!-- ===================================================== -->
<!--  RETOUR FICHE ENGIN                                    -->
<!-- ===================================================== -->

<br>
<a class="btn" href="admin-engin-fiche.php?id=<?= urlencode($id) ?>">⬅ Retour fiche engin</a>

<?php include "admin-footer.php"; ?>

</body>
</html>
