<?php
// ==========================================================
//  DOCUMENTS ENGIN — ADMIN
// ==========================================================

include "admin-header.php";

$id = $_GET["id"] ?? "";
if ($id === "") die("ID manquant.");

// Chemins
$clientBase = $config["paths"]["clients"] . "/" . $client;
$docsDir    = $clientBase . "/" . $config["paths"]["documents"] . "/engins/" . $id;

// Créer dossier si absent
if (!is_dir($docsDir)) {
    mkdir($docsDir, 0775, true);
}

$message = "";

// ==========================================================
//  UPLOAD PDF
// ==========================================================
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_FILES["pdf"])) {

    $f = $_FILES["pdf"];

    if ($f["error"] === UPLOAD_ERR_OK) {

        $name = basename($f["name"]);
        $target = $docsDir . "/" . $name;

        if (move_uploaded_file($f["tmp_name"], $target)) {
            $message = "Document importé : $name";
        } else {
            $message = "Erreur lors de l'import.";
        }

    } else {
        $message = "Erreur upload fichier.";
    }
}

?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">
<title>Documents engin</title>

<style>
.msg{
    padding:10px;
    background:#e0ffe0;
    border:1px solid green;
    margin-bottom:15px;
}
.btn{
    display:inline-block;
    padding:10px 15px;
    background:#007bff;
    color:white;
    text-decoration:none;
    border-radius:5px;
    margin-top:15px;
}
.btn:hover{ background:#0056b3; }
.file-btn{
    background:#f1f1f1;
    padding:8px;
    display:block;
    margin:6px 0;
    border-radius:5px;
}
</style>

</head>
<body>

<h2>Documents – Engin <?= htmlspecialchars($id) ?></h2>

<?php if ($message): ?>
<p class="msg"><?= htmlspecialchars($message) ?></p>
<?php endif; ?>

<h3>Importer un document PDF</h3>

<form method="post" enctype="multipart/form-data">
    <input type="file" name="pdf" accept="application/pdf" required>
    <button type="submit">Importer</button>
</form>

<hr>

<h3>Documents existants</h3>

<?php
$files = glob($docsDir . "/*.pdf");
if (!$files):
    echo "<p>Aucun document pour cet engin.</p>";
else:
    foreach ($files as $pdf):
        $basename = basename($pdf);
?>
    <a class="file-btn" href="<?= "/data/clients/$client/documents/engins/$id/$basename" ?>" target="_blank">
        📄 <?= htmlspecialchars($basename) ?>
    </a>
<?php
    endforeach;
endif;
?>

<br><br>
<a class="btn" href="admin-engin-fiche.php?id=<?= urlencode($id) ?>">⬅ Retour fiche engin</a>

<?php include "admin-footer.php"; ?>
</body>
</html>
