<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// ======================================================
// Sécurité
// ======================================================
if (empty($_SESSION['logged']) || $_SESSION['logged'] !== true) {
    header("Location: admin-login.php");
    exit;
}

$client = $_GET['client'] ?? '';
$id     = $_GET['id'] ?? '';

if ($client === '' || $id === '') {
    die("Paramètres invalides.");
}

$basePath = "/var/www/docnlink/data/clients/$client";
$docsPath = "$basePath/documents/engins/$id";

// Création auto du dossier s'il n'existe pas
if (!is_dir($docsPath)) {
    mkdir($docsPath, 0775, true);
}

function h($s) { return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }

// ======================================================
// SUPPRESSION DOCUMENT
// ======================================================
if (isset($_GET['delete'])) {
    $file = basename($_GET['delete']);
    $full = "$docsPath/$file";

    if (file_exists($full)) {
        unlink($full);
    }

    header("Location: admin-documents-engin.php?client=$client&id=$id");
    exit;
}

// ======================================================
// UPLOAD DOCUMENT
// ======================================================
$message = "";

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_FILES["doc"])) {

    $f = $_FILES["doc"];
    
    if ($f["error"] === UPLOAD_ERR_OK) {

        $name = basename($f["name"]);
        $dest = "$docsPath/$name";

        // Vérifier PDF uniquement
        $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
        if ($ext !== "pdf") {
            $message = "Seuls les fichiers PDF sont acceptés.";
        } else {
            move_uploaded_file($f["tmp_name"], $dest);
            $message = "Document ajouté.";
        }

    } else {
        $message = "Erreur upload.";
    }
}

// ======================================================
// LISTE DOCUMENTS
// ======================================================
$docs = array_diff(scandir($docsPath), ['.', '..']);
?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">
<title>Admin — Documents engin <?= h($id) ?></title>

<style>
body { font-family: Arial; background:#f5f5f5; margin:0; }
.header {
    background:#0057D9; color:white;
    padding:15px; font-size:20px; font-weight:bold;
}
.container { padding:20px; }
.section {
    background:white; padding:15px;
    margin-bottom:20px; border-radius:8px;
}
.title { font-size:18px; font-weight:bold; margin-bottom:10px; }

.btn {
    display:block; width:100%; background:#0057D9;
    color:white; padding:12px; text-align:center;
    border-radius:6px; font-size:16px; text-decoration:none;
    margin-top:10px;
}
.btn-small {
    background:#c00000; padding:6px 10px; color:white;
    border-radius:4px; font-size:14px; text-decoration:none;
}
.file-item { margin-bottom:12px; }
</style>
</head>

<body>

<div class="header">
ADMIN — Documents engin <?= h($id) ?> — Client <?= h($client) ?>
</div>

<div class="container">

    <!-- MESSAGE -->
    <?php if ($message): ?>
        <div style="color:green; font-weight:bold;"><?= h($message) ?></div>
    <?php endif; ?>

    <!-- LISTE DOCUMENTS -->
    <div class="section">
        <div class="title">Documents existants</div>

        <?php if (empty($docs)): ?>
            <p>Aucun document.</p>
        <?php else: ?>
            <?php foreach ($docs as $d): ?>
                <div class="file-item">
                    <a href="/data/clients/<?= h($client) ?>/documents/engins/<?= h($id) ?>/<?= h($d) ?>"
                       target="_blank">
                        📄 <?= h($d) ?>
                    </a>

                    &nbsp;&nbsp;

                    <a class="btn-small"
                       onclick="return confirm('Supprimer ce document ?');"
                       href="admin-documents-engin.php?client=<?= h($client) ?>&id=<?= h($id) ?>&delete=<?= h($d) ?>">
                        Suppr
                    </a>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>

    <!-- UPLOAD -->
    <div class="section">
        <div class="title">Ajouter un document PDF</div>

        <form method="post" enctype="multipart/form-data">
            <input type="file" name="doc" accept="application/pdf" required>
            <button class="btn" type="submit">Uploader</button>
        </form>
    </div>

    <a class="btn" href="admin-engin-fiche.php?client=<?= h($client) ?>&id=<?= h($id) ?>">
        ⬅ Retour fiche engin
    </a>

</div>

</body>
</html>
