<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

// Chargement config (CHEMIN CORRIGÉ)
$config = require __DIR__ . '/../../config/admin.php';

$superAdmin  = $config['super_admin']   ?? [];
$clientsAdmin = $config['clients_admin'] ?? [];
$paths        = $config['paths']         ?? [];

// Vérification connexion admin
if (empty($_SESSION['logged']) || $_SESSION['logged'] !== true) {
    header("Location: admin-login.php");
    exit;
}

?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Panneau d'administration</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f5f5f5;
            margin: 0;
        }
        .header {
            background: #0066ff;
            padding: 15px;
            color: white;
            font-size: 20px;
            font-weight: bold;
        }
        .container {
            margin: 20px;
            background: white;
            padding: 20px;
            border-radius: 5px;
        }
        input[type=text] {
            padding: 6px;
            width: 200px;
        }
        button {
            padding: 6px 12px;
            background: #0066ff;
            color: white;
            border: none;
            cursor: pointer;
        }
        button:hover {
            background: #004ecc;
        }
        a { color: #0066ff; }
    </style>
</head>
<body>

<div class="header">
    Panneau d'administration
</div>

<div class="container">

    <h2>Mode superadmin</h2>

    <p>Vous êtes connecté en superadmin.</p>

    <?php
    // Message si un code invalide a été envoyé
    if (!empty($_GET['err'])) {
        echo "<p style='color:red;font-weight:bold'>Erreur : code client invalide.</p>";
    }
    ?>

    <form action="select-client.php" method="GET">
        <label>Veuillez entrer un code client pour gérer un client :</label><br><br>
        <input type="text" name="client" placeholder="Code client">
        <button type="submit">Valider</button>
    </form>

    <br><br>
    <a href="admin-logout.php">Déconnexion</a>

</div>

</body>
</html>
